import refreshTokenHelper from "../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.uomId) {
    newObjValue = {...newObjValue, 
      C_UOM_ID: {
        id: body.uomId,
        tableName: 'C_UOM'
      }
    }
  }
  if(body.warehouseId) {
    newObjValue = {...newObjValue, 
      M_Warehouse_ID: {
        id: body.warehouseId,
        tableName: 'M_Warehouse'
      }
    }
  }
  if(body.currencyId) {
    newObjValue = {...newObjValue, 
      C_Currency_ID: {
        id: body.currencyId,
        tableName: 'C_Currency'
      }
    }
  }
  if(body.taxId) {
    newObjValue = {...newObjValue, 
      C_Tax_ID: {
        id: body.taxId,
        tableName: 'C_Tax'
      }
    }
  }
  if(body.partnerId) {
    newObjValue = {...newObjValue, 
      C_BPartner_ID: {
        id: body.partnerId,
        tableName: 'C_BPartner'
      }
    }
  }
  if(body.partnerLocationId) {
    newObjValue = {...newObjValue, 
      C_BPartner_Location_ID: {
        id: body.partnerLocationId,
        tableName: 'C_BPartner_Location'
      }
    }
  }
  if(body.attributeSetInstanceId) {
    newObjValue = {...newObjValue, 
      M_AttributeSetInstance_ID: {
        id: body.attributeSetInstanceId,
        tableName: 'M_AttributeSetInstance'
      }
    }
  }
  if(body.chargeId) {
    newObjValue = {...newObjValue, 
      C_Charge_ID: {
        id: body.chargeId,
        tableName: 'C_Charge'
      }
    }
  }
  if(body.projectId) {
    newObjValue = {...newObjValue, 
      C_Project_ID: {
        id: body.projectId,
        tableName: 'C_Project'
      }
    }
  }
  if(body.campaignId) {
    newObjValue = {...newObjValue, 
      C_Campaign_ID: {
        id: body.campaignId,
        tableName: 'C_Campaign'
      }
    }
  }

  if(body.id) {
    const res: any = await event.context.fetch('models/c_orderline/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      line: body.line,
      dateOrdered: body.dateOrdered,
      datePromised: body.datePromised,
      dateInvoiced: body.dateInvoiced,
      qtyOrdered: body.qtyOrdered,
      qtyReserved: body.qtyReserved,
      qtyDelivered: body.qtyDelivered,
      qtyInvoiced: body.qtyInvoiced,
      qtyEntered: body.qtyEntered,
      qtyLostSales: body.qtyLostSales,
      priceList: body.priceList,
      priceActual: body.priceActual,
      priceLimit: body.priceLimit,
      priceEntered: body.priceEntered,
      freightAmt: body.freightAmt,
      discount: body.discount,
      isDescription: body.isDescription,
      description: body.description,
      processed: body.processed,
      ...newObjValue,
      tableName: 'C_Orderline'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})